#ifndef HIPERGRAFO_H_
#define HIPERGRAFO_H_
#include <iostream>
using std::cout;
using std::endl;
using std::ostream;
namespace cap7_listincidencia {
	class HiperGrafo {
	public:
		class Aresta {
    friend class HiperGrafo;
    friend ostream& operator<< (ostream& out, const Aresta& aresta) {
      out << "{"; int i = 0;
      for (i = 0; i < aresta.r-1; i++) 
        out << aresta.vertices[i] << ", "; 
      out << aresta.vertices[i] << "} (" << aresta.peso << ")";
      return out;
    }    
	  private:
	    int * vertices;
	    int r, peso; 
	  public: 
	    Aresta (int *vertices, int peso, int r) {
	      this->vertices = new int[r];
        for (int i = 0; i < r; i++)
          this->vertices[i] = vertices[i];
	      this->peso = peso; this->r = r;
	    }
	    int _peso () { return this->peso; }
	    int vertice (int i) { return this->vertices[i]; }
	    int *_vertices () { return this->vertices; }
	    bool operator== (const Aresta& aresta) const {
	      if (aresta.r != this->r) return false;
	      for (int i = 0; i < this->r; i++)
	        if (this->vertices[i] != aresta.vertices[i]) return false;
	      return true;
      }      	    
      bool operator!= (const Aresta& aresta) const {
         return !(*this == aresta);
      }
      
	    ~Aresta () { if (this->vertices) delete this->vertices; }
	  };
	private:
    int numVertices, numArestas, proxDisponivel, r;
    Aresta **arestas;
    int *prim, *prox;
    int *pos; 
  public:
    HiperGrafo (int numVertices, int numArestas, int r);
	  void insereAresta (int *vertices, int peso);
	  bool existeAresta (int *vertices) const;
	  bool listaIncVazia (int v) const;
	  Aresta *primeiraListaInc (int v);
	  Aresta *proxInc (int v);
	  Aresta *retiraAresta (int *vertices);
	  void imprime () const ;
	  int _numVertices () const;
    ~HiperGrafo ();	  
	};
  HiperGrafo::HiperGrafo (int numVertices, int numArestas, int r) {
	  this->arestas = new Aresta*[numArestas]; 
    this->prim = new int[numVertices];
    for (int i = 0; i < numVertices; i++) this->prim[i] = -1;
    this->prox = new int[r*numArestas]; this->numVertices = numVertices;
    this->proxDisponivel = 0; this->r = r; 
    this->numArestas = numArestas; this->pos = new int[numVertices];
  }	  
  void HiperGrafo::insereAresta (int *vertices, int peso) {
    if (this->proxDisponivel == this->numArestas)
      cout << "Nao ha espaco disponivel para a aresta" << endl;
    else {
      int a = this->proxDisponivel++; int n = this->numArestas;
      this->arestas[a] = new Aresta (vertices, peso, this->r);
      for (int i = 0; i < this->r; i++) {
        int ind = a + i*n;
        this->prox[ind] = this->prim[this->arestas[a]->vertices[i]]; 
        this->prim[this->arestas[a]->vertices[i]] = ind;
      }
    }
  }
  bool HiperGrafo::existeAresta (int *vertices) const {
    for (int v = 0; v < this->r; v++) 
      for (int i = this->prim[vertices[v]]; i != -1; i = this->prox[i]) {
        int a = i % this->numArestas;
        Aresta aresta(vertices, 0, this->r);
        if (*(this->arestas[a]) == aresta) 
          return true; 
      }      
    return false;
  }
 // @{\it Operadores para obter a lista de arestas incidentes}@  
  bool HiperGrafo::listaIncVazia (int v) const {
    return (this->prim[v] == -1);
  }	  
  HiperGrafo::Aresta *HiperGrafo::primeiraListaInc (int v) {
    // @{\it Retorna a primeira aresta incidente no v\'ertice v ou}@
    // @{\it {\bf NULL} se a lista de arestas incidentes em v for vazia}@
    this->pos[v] = this->prim[v];
    int a = this->pos[v] % this->numArestas;
    if (a >= 0) return this->arestas[a]; else return NULL;
  }
  HiperGrafo::Aresta *HiperGrafo::proxInc (int v) {
    // @{\it Retorna a pr\'oxima aresta incidente no v\'ertice v ou {\bf NULL}}@
    // @{\it  se a lista de arestas incidentes em v estiver no fim}@
    this->pos[v] = this->prox[this->pos[v]];
    int a = this->pos[v] % this->numArestas;
    if (a >= 0) return this->arestas[a]; else return NULL;
  }
  HiperGrafo::Aresta *HiperGrafo::retiraAresta (int *vertices) {
    int n = this->numArestas, a = 0; Aresta *aresta = NULL;
    for (int i = 0; i < this->r; i++) {
      int prev = -1, aux = this->prim[vertices[i]];
      a = aux % n; aresta = new Aresta (vertices, 0, this->r);
      while ((aux >= 0) && (*(this->arestas[a]) != *aresta)) {
        prev = aux; aux = this->prox[aux]; a = aux % n;
      }
      delete aresta;
      if (aux >= 0) { // @{\it achou}@
        if (prev == -1) this->prim[vertices[i]] = this->prox[aux];
        else this->prox[prev] = this->prox[aux];        
        aresta = this->arestas[a];        
      } else return NULL; // @{\it n\~ao achou}@
    }
    this->arestas[a] = NULL; // @{\it Marca como removido}@
    return aresta;
  }
  void HiperGrafo::imprime () const {
    for (int i = 0; i < this->numVertices; i++) { 
      cout << "Vertice " << i << ":" << endl;
      for (int j = this->prim[i]; j != -1; j = this->prox[j]) {
        int a = j % this->numArestas;
        cout << "  a: " << *(this->arestas[a]) << endl;
      }
    }
  }

  int HiperGrafo::_numVertices () const { return this->numVertices; }

  HiperGrafo::~HiperGrafo () {
    for(int i = 0; i < this->numArestas; i++) 
      if (this->arestas[i]) delete this->arestas[i];
    delete [] this->arestas; delete [] this->prim;
    delete [] this->prox;    delete [] this->pos;
  }	  
}

#endif 

		
