package cap7.listincidencia;
public class HiperGrafo {
  public static class Aresta {
    private int vertices[];
    private int peso;
    public Aresta (int vertices[], int peso) {
      this.vertices = vertices; this.peso = peso;
    }
    public int peso () { return this.peso; }
    public int vertice (int i) { return this.vertices[i]; }
    public int[] vertices () { return this.vertices; }
    public boolean equals (Object aresta) {
      Aresta a = (Aresta)aresta;
      if (a.vertices.length != this.vertices.length) return false;
      for (int i = 0; i < this.vertices.length; i++)
        if (this.vertices[i] != a.vertices[i]) return false;
      return true;
    }
    public String toString () {
      String res = "{"; int i = 0;
      for (i = 0; i < this.vertices.length-1; i++) 
        res += this.vertices[i] + ", "; 
      res += this.vertices[i] + "} (" + this.peso + ")";
      return res;
    }
  }
  private int numVertices, proxDisponivel, r;
  private Aresta arestas[];
  private int prim[], prox[];
  private int pos[]; 
  
  public HiperGrafo (int numVertices, int numArestas, int r) {
    this.arestas = new Aresta[numArestas]; 
    this.prim = new int[numVertices];
    for (int i = 0; i < numVertices; i++) this.prim[i] = -1;
    this.prox = new int[r*numArestas]; this.numVertices = numVertices;
    this.proxDisponivel = 0; this.r = r; this.pos = new int[numVertices];
  } //@\lstcontinue@
  public void insereAresta (int vertices[], int peso) {
    if (this.proxDisponivel == this.arestas.length)
      System.out.println ("Nao ha espaco disponivel para a aresta");
    else {
      int a = this.proxDisponivel++; int n = this.arestas.length;
      this.arestas[a] = new Aresta (vertices, peso);
      for (int i = 0; i < this.r; i++) {
        int ind = a + i*n;
        this.prox[ind] = this.prim[this.arestas[a].vertices[i]]; 
        this.prim[this.arestas[a].vertices[i]] = ind;
      }
    }
  } 
  public boolean existeAresta (int vertices[]) {
    for (int v = 0; v < this.r; v++) 
      for (int i = this.prim[vertices[v]]; i != -1; i = this.prox[i]) {
        int a = i % this.arestas.length;
        if (this.arestas[a].equals (new Aresta (vertices, 0))) 
          return true; 
      }      
    return false;
  } 
 /*-- @{\it Operadores para obter a lista de arestas incidentes}@ --*/
  public boolean listaIncVazia (int v) { return (this.prim[v] == -1); }
  public Aresta primeiraListaInc (int v) {
    /*-- @{\it Retorna a primeira aresta incidente no v\'ertice v ou}@  --*
     *-- @{\it {\bf null} se a lista de arestas incidentes em v for vazia}@   --*/
    this.pos[v] = this.prim[v];
    int a = this.pos[v] % this.arestas.length;
    if (a >= 0) return this.arestas[a]; else return null;
  }
  public Aresta proxInc (int v) {
    /*-- @{\it Retorna a pr\'oxima aresta incidente no v\'ertice v ou {\bf null}}@ --*
     *-- @{\it  se a lista de arestas incidentes em v estiver no fim}@      --*/
    this.pos[v] = this.prox[this.pos[v]];
    int a = this.pos[v] % this.arestas.length;
    if (a >= 0) return this.arestas[a]; else return null;
  }
  public Aresta retiraAresta (int vertices[]) {
    int n = this.arestas.length, a = 0; Aresta aresta = null;
    for (int i = 0; i < this.r; i++) {
      int prev = -1, aux = this.prim[vertices[i]];
      a = aux % n; aresta = new Aresta (vertices, 0);
      while ((aux >= 0) && (!this.arestas[a].equals (aresta))) {
        prev = aux; aux = this.prox[aux]; a = aux % n;
      }//@\lstcontinue@
      if (aux >= 0) { // @{\it achou}@
        if (prev == -1) this.prim[vertices[i]] = this.prox[aux];
        else this.prox[prev] = this.prox[aux];
        aresta = this.arestas[a];        
      } else return null; // @{\it n\~ao achou}@
    }
    this.arestas[a] = null; // @{\it Marca como removido}@
    return aresta;
  } 
  public void imprime () {
    for (int i = 0; i < this.numVertices; i++) { 
      System.out.println ("Vertice " + i + ":");
      for (int j = this.prim[i]; j != -1; j = this.prox[j]) {
        int a = j % this.arestas.length;
        System.out.println ("  a: " + this.arestas[a]);
      }
    }
  }
  public int numVertices () { return this.numVertices; }
}
