#ifndef CASAMENTOEXATO_H_
#define CASAMENTOEXATO_H_
#include <string>
#include <iostream>
using std::cout;
using std::endl;
using std::string;
namespace cap8 {
	class CasamentoExato {
	private: 
	  static const int maxChar;
	public:
	  static void forcaBruta (string T, int n, string P, int m);
	  static void shiftAndExato (string T, int n, string P, int m);
	  static void bmh (string T, int n, string P, int m);
	  static void bmhs (string T, int n, string P, int m);
	};
	const int CasamentoExato::maxChar = 256;
  void CasamentoExato::forcaBruta (string T, int n, string P, int m) {
    // @{\it Pesquisa P[0..m-1] em T[0..n-1]}@
    for (int i = 0; i < (n - m + 1); i ++) {
      int k = i; int j = 0;
      while ((j < m) && (T[k] == P[j])) { j++; k++; }
      if (j == m) cout << "Casamento na posicao: " << i << endl;
    }
  }
  void CasamentoExato::shiftAndExato (string T, int n, string P, int m) {
    int R = 0;
    // @{\it Pr\'e-processamento do padr\~ao}@
    int *M = new int[maxChar];
    for (int i = 0; i < maxChar; i++) M[i] = 0;
    for (int j = 0; j < m; j++) 
      M[(unsigned char)P[j]] = M[(unsigned char)P[j]] | (1 << (m - j - 1));
    // @{\it Pesquisa}@
    for (int i = 0; i < n; i++) {
      R = ((R >> 1) | (1 << (m - 1))) & M[(unsigned char)T[i]];
      if ((R & 1) != 0) 
        cout << "Casamento na posicao: " << (i - m + 1) << endl;
    }
    delete [] M;
  }
  void CasamentoExato::bmh (string T, int n, string P, int m) {
    // @{\it Pr\'e-processamento do padr\~ao}@
    int *d = new int[maxChar];
    for (int j = 0; j < maxChar; j++) d[j] = m;
    for (int j = 0; j < (m-1); j++) d[(unsigned char)P[j]] = m - j - 1;
    int i = m - 1;
    while (i < n) { // @{\it Pesquisa}@
      int k = i; int j = m - 1;
      while ((j >= 0) && (T[k] == P[j])) { j--; k--; }
      if (j < 0)
        cout << "Casamento na posicao: " << (k + 1) << endl;
      i = i + d[(unsigned char)T[i]];      
    }
    delete [] d;
  }
  void CasamentoExato::bmhs (string T, int n, string P, int m) {
    // @{\it Pr\'e-processamento do padr\~ao}@
    int *d = new int[maxChar];
    for (int j = 0; j < maxChar; j++) d[j] = m + 1;
    for (int j = 0; j < m; j++) d[(unsigned char)P[j]] = m - j;
    int i = m - 1;
    while (i < n) { // @{\it Pesquisa}@
      int k = i; int j = m - 1;
      while ((j >= 0) && (T[k] == P[j])) { j--; k--; } 
      if (j < 0)
        cout << "Casamento na posicao: " << (k + 1) << endl;
      i += i != (n-1) ? d[(unsigned char)T[i+1]] : 1;
    }    
    delete [] d;
  }
}
#endif
