#ifndef _EXTRAIPALAVRA_H_
#define _EXTRAIPALAVRA_H_
#include <string>
#include <iostream>
#include <fstream>
using std::ios;
using std::filebuf;
using std::istream;
using std::string;
#define ASCII 256
#define MAX_TAM_LINHA 1000
namespace cap8 {
  class ExtraiPalavra {
  private:
    istream *arqDelim, *arqTxt;
    filebuf fArqDelim, fArqTxt;
    string *delimitadores;
    string *palavras, palavraAnt;
    string::size_type pos;
    bool eDelimitador (char ch) {
      return (this->delimitadores->find(ch) != string::npos);
    }
  public:
    ExtraiPalavra (string nomeArqDelim, string nomeArqTxt);    
    string *proximaPalavra ();
    ~ExtraiPalavra (); // @{\it Fecha os arquivos e libera mem\'oria alocada}@
  };
  ExtraiPalavra::ExtraiPalavra (string nomeArqDelim, string nomeArqTxt) {
    this->fArqDelim.open (nomeArqDelim.c_str(), ios::in);
    this->arqDelim = new istream(&this->fArqDelim);
    this->fArqTxt.open (nomeArqTxt.c_str(), ios::in);
    this->arqTxt = new istream(&this->fArqTxt);      
    // @{\it Os delimitadores devem estar juntos em uma \'unica linha do arquivo}@ 
    char delim[ASCII];
    arqDelim->getline(delim, ASCII);
    this->delimitadores = new string(delim);
    *(this->delimitadores) =  *(this->delimitadores) + "\r\n"; 
    this->palavras = NULL; this->pos = 0; this->palavraAnt = " ";
  }     
  
  string *ExtraiPalavra::proximaPalavra () {
    if (palavras == NULL || (this->pos == string::npos)) {
      char linha[MAX_TAM_LINHA];
      arqTxt->getline (linha, MAX_TAM_LINHA);
      if (strlen (linha) == 0 && arqTxt->eof ()) return NULL;
      if (this->palavras) delete this->palavras;
      this->palavras = new string (linha);  this->pos = 0;
      *(this->palavras) = *(this->palavras) + "\n";
    }
    string *palavra = new string("");
    if (this->eDelimitador ((*(this->palavras))[this->pos])) {
      string::size_type posFinal = this->palavras->find_first_not_of(*(this->delimitadores), 
                                                                     this->pos);
      *palavra = this->palavras->substr(this->pos, posFinal - this->pos);
      this->pos = posFinal;
    }
    else {
      this->pos = this->palavras->find_first_not_of(*(this->delimitadores), 
                                                    this->pos);
      string::size_type posFinal = this->palavras->find_first_of (
                                   *(this->delimitadores), this->pos);
      if (string::npos != posFinal || string::npos != this->pos) {
        *palavra = this->palavras->substr(this->pos, posFinal - this->pos);
        this->pos = posFinal;
      }
    }
    if (palavra->length () == 1 && (*palavra == " ") &&
        this->pos != string::npos && !eDelimitador (palavraAnt[0]) && 
        !eDelimitador ((*(this->palavras))[this->pos])) { 
      delete palavra; palavra = new string("");
    } palavraAnt = *palavra; return palavra;
  }
  ExtraiPalavra::~ExtraiPalavra () { // @{\it Fecha os arquivos e libera mem\'oria alocada}@
      fArqDelim.close(); delete arqDelim; fArqTxt.close(); 
      delete arqTxt; delete delimitadores;
      if(this->palavras) delete this->palavras;
  }    
}
#endif
