#ifndef HUFFMAN_H_
#define HUFFMAN_H_
#include "HuffmanByte.h" // @{\it vide Programa~\ref{prog:huffmanbytec}}@ 
#include <iostream>
using std::cout;
using std::cin;
using std::endl;
namespace cap8 {
	class Huffman {
	private:
    static const int baseNum;
    static const int m;
    static const int maxTamPalavra;
    static void imprime (string msg);
  public:
    static void main ();	
	};
	const int Huffman::baseNum = 128;
  const int Huffman::m = 67001;
  const int Huffman::maxTamPalavra = 35;
  void Huffman::imprime (string msg) { cout << msg; }
  void Huffman::main () {
    imprime ("Arquivo com os delimitadores em uma linha:"); 
    string nomeArqDelim = ""; cin >> nomeArqDelim;
    string opcao = "";
    do {
      imprime ("**************************************\n");
      imprime ("*               Opcoes               *\n");
      imprime ("*------------------------------------*\n");
      imprime ("* (c) Compressao                     *\n");
      imprime ("* (d) Descompressao                  *\n");
      imprime ("* (p) Pesquisa no texto comprimido   *\n");
      imprime ("* (f) Termina                        *\n");
      imprime ("**************************************\n");
      imprime ("* Opcao:"); cin >> opcao;
      if (opcao == "c") {
         imprime ("Arquivo texto a ser comprimido:"); 
         string nomeArqTxt = ""; cin >> nomeArqTxt;
         imprime ("Arquivo comprimido a ser gerado:");
         string nomeArqComp = ""; cin >> nomeArqComp;
         HuffmanByte huff (nomeArqDelim, baseNum, m, maxTamPalavra);
         huff.compressao (nomeArqTxt, nomeArqComp);
      }
      else if (opcao == "d") {
        imprime ("Arquivo comprimido a ser descomprimido:");
        string nomeArqComp = ""; cin >> nomeArqComp;
        imprime ("Arquivo texto a ser gerado:");
        string nomeArqTxt = ""; cin >> nomeArqTxt;
        HuffmanByte huff (nomeArqDelim, baseNum, m, maxTamPalavra);
        huff.descompressao (nomeArqTxt, nomeArqComp);
      }
      else if (opcao == "p") {
        imprime ("Arquivo comprimido para ser pesquisado:");
        string nomeArqComp = ""; cin >> nomeArqComp;
        HuffmanByte huff ("", baseNum, m, maxTamPalavra);
        huff.busca (nomeArqComp);        
      }
    } while (opcao != "f");
  }		
}
#endif
