#ifndef _HUFFMANBYTE_H_
#define _HUFFMANBYTE_H_
#include "../cap4/ordenacaointerna/Ordenacao.h" // @{\it vide Programa~\ref{c_4.2}}@
#include "../cap5/endaberto/TabelaHash.h" // @{\it vide Programa~\ref{c_5.26}}@
#include "ExtraiPalavra.h" // @{\it vide Programa~\ref{c_8.22}}@
#include "ItemVoc.h" // @{\it vide Programa~\ref{prog:itemvocc}}@
#include "CasamentoExato.h" // @{\it vide Programa~\ref{c_8.1}}@
#include <string>
#include <iostream>
#include <fstream>
#include <math.h>
using std::iostream;
using std::filebuf;
using std::string;
using cap4_ordenacaointerna::Ordenacao; // @{\it vide Programa~\ref{c_4.2}}@
using cap5_endaberto::TabelaHash; // @{\it vide Programa~\ref{c_5.26}}@
namespace cap8 {
  class HuffmanByte {
  private: 
    int baseNum;
    int *base, *offset;
    iostream *arqComp; // @{\it Arquivo comprimido}@
    string nomeArqTxt, nomeArqDelim;
    TabelaHash<ItemVoc> *vocabulario;
    class Codigo {
    public:
      int codigo;
      int c; // @{\it Comprimento do c\'odigo}@
    }; 
    void calculaCompCodigo (ItemVoc **A, int n) const;
    void primeiraEtapa () const;  
    ItemVoc **ordenaPorFrequencia (int &n) const;
    int constroiVetores (ItemVoc **A, int n);
    int segundaEtapa ();
    Codigo *codifica (int ordem, int maxCompCod) const;
    void escreve (Codigo *cod, int maxCompCod) const;
    void terceiraEtapa (int maxCompCod) const;  
    // @{\it M\'etodos para descompress\~ao}@
    int leVetores ();
    string *leVocabulario (int &n) const;
    int decodifica (int maxCompCod) const;    
    bool eDelimitador (string delim, char ch) const;
    // @{\it M\'etodo auxiliar utilizado na busca em arquivo comprimido}@  
    string atribui (Codigo *cod) const;
  public:
    HuffmanByte (string nomeArqDelim, int baseNum, int m, int maxTamChave);
    void compressao (string nomeArqTxt, string nomeArqComp);    
    void descompressao (string nomeArqTxt, string nomeArqComp);
    void busca (string nomeArqComp);   
    ~HuffmanByte ();
  };
  void HuffmanByte::calculaCompCodigo (ItemVoc **A, int n) const {
    int resto = 0;
    if (n > (this->baseNum - 1)) {
      resto = 1 + ((n - this->baseNum) % (this->baseNum - 1));
      if (resto < 2) resto = this->baseNum;
    }
    else resto = n - 1;
    // @{\it noInt: N\'umero de nodos internos}@
    int noInt = 1 + ((n - resto) / (this->baseNum - 1));
    int freqn = A[n]->recuperaChave ();
    for (int x = (n - 1); x >= (n - resto + 1); x--) {
      int freqx = A[x]->recuperaChave ();      
      freqn = freqn + freqx; 
    }
    A[n]->alteraChave (freqn);
    // @{\it Primeira Fase}@
    int raiz = n; int folha = n - resto; int prox;
    for (prox = n - 1; prox >= (n - noInt + 1); prox--) {
      // @{\it Procura Posi\c{c}\~ao}@
      int freqraiz = A[raiz]->recuperaChave ();
      if ((folha < 1) || ((raiz > prox) && 
          (freqraiz <= A[folha]->recuperaChave ()))) {
        // @{\it N\'o interno}@
        A[prox]->alteraChave (freqraiz);
        A[raiz]->alteraChave (prox); raiz--;
      }
      else { // @{\it N\'o folha}@
        int freqfolha = A[folha]->recuperaChave ();
        A[prox]->alteraChave (freqfolha); folha--;
      }
      // @{\it Atualiza Freq\"u\^encias}@
      for (int x = 1; x <= (this->baseNum - 1); x++) {
        freqraiz = A[raiz]->recuperaChave ();
        int freqprox = A[prox]->recuperaChave ();
        if ((folha < 1) || ((raiz > prox) && 
            (freqraiz <= A[folha]->recuperaChave ()))) {
          // @{\it N\'o interno}@
          A[prox]->alteraChave (freqprox + freqraiz);
          A[raiz]->alteraChave (prox); raiz--;
        }
        else { // @{\it N\'o folha}@
          int freqfolha = A[folha]->recuperaChave ();
          A[prox]->alteraChave (freqprox + freqfolha); folha--;
        }
      }
    }
    // @{\it Segunda Fase}@
    A[raiz]->alteraChave (0);
    for (prox = raiz + 1; prox <= n; prox++) {
      int pai = A[prox]->recuperaChave ();
      int profundidadepai = A[pai]->recuperaChave ();
      A[prox]->alteraChave (profundidadepai + 1);
    }
    // @{\it Terceira Fase}@
    int disp = 1; int u = 0; int h = 0; prox = 1;
    while (disp > 0) {
      while ((raiz <= n) && (A[raiz]->recuperaChave () == h)) {
        u++; raiz++;
      }
      while (disp > u) {
        A[prox]->alteraChave (h); prox++; disp--;
        if (prox > n) { u = 0; break; }
      }
      disp = this->baseNum * u; h = h + 1; u = 0;
    }
  }
  void HuffmanByte::primeiraEtapa () const {
    ExtraiPalavra palavras (this->nomeArqDelim, this->nomeArqTxt);
    string *palavra = NULL;
    while ((palavra = palavras.proximaPalavra()) != NULL) {
      // @{\it O primeiro espa\c{c}o depois da palavra n\~ao \'e codificado}@
      if (*palavra == "") { delete palavra; continue;}      
      ItemVoc *itemVoc = this->vocabulario->pesquisa (*palavra);
      if ( itemVoc != NULL) { // @{\it Incrementa freq\"u\^encia}@
        int freq = itemVoc->recuperaChave ();
        itemVoc->alteraChave (freq + 1);
      } else { // @{\it Insere palavra com freq\"u\^encia 1}@
        itemVoc = new ItemVoc (*palavra, 1, 0);
        this->vocabulario->insere (*palavra, *itemVoc);
        delete itemVoc;
      }
      delete palavra;  
    }
  }    
  ItemVoc **HuffmanByte::ordenaPorFrequencia (int &n) const {
    ItemVoc **aux = this->vocabulario->recuperaItens (n);
    Item<int> **A = new Item<int>*[n+1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    for (int i = 0; i < n; i++) {
    	A[i+1] = aux[i];
    }
    delete [] aux; Ordenacao<int>::quicksort (A, n);
    return (ItemVoc **)A;
  }
  int HuffmanByte::constroiVetores (ItemVoc **A, int n) {
    int maxCompCod = A[n]->recuperaChave();
    int *wcs = new int[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    if (this->offset) delete [] this->offset;
    this->offset = new int[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    if (this->base) delete [] this->base;
    this->base = new int[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    for (int i = 1; i <= maxCompCod; i++) wcs[i] = 0;
    for (int i = 1; i <= n; i++) {
      int freq = A[i]->recuperaChave(); 
      wcs[freq]++; this->offset[freq] = i - wcs[freq] + 1;
    }
    this->base[1] = 0;
    for (int i = 2; i <= maxCompCod; i++) {
      this->base[i] = this->baseNum * (this->base[i-1] + wcs[i-1]);
      if (this->offset[i] == 0) this->offset[i] = this->offset[i-1];
    }
    // @{\it Salvando as tabelas em disco}@
    this->arqComp->write((char *)&maxCompCod, sizeof (maxCompCod));
    for (int i = 1; i <= maxCompCod; i++) {
      this->arqComp->write ((char *)&(this->base[i]), sizeof (this->base[i]));
      this->arqComp->write ((char *)&(this->offset[i]), sizeof (this->offset[i]));
    }
    delete [] wcs;
    return maxCompCod;
  }
  int HuffmanByte::segundaEtapa () {
    int n = 0;
    ItemVoc **A = this->ordenaPorFrequencia (n);
    this->calculaCompCodigo (A, n);
    int maxCompCod = this->constroiVetores (A, n);
    // @{\it Grava Vocabul\'ario}@
    this->arqComp->write ((char *)&n, sizeof (n));    
    for (int i = 1; i <= n; i++) {
      string palavra = A[i]->_palavra ();
      this->arqComp->write (palavra.c_str (), palavra.length ());
      char ch = '\0'; this->arqComp->write (&ch, sizeof (ch));
      A[i]->alteraOrdem (i);
    }
    delete [] A;
    return maxCompCod;
  }
  HuffmanByte::Codigo *HuffmanByte::codifica (int ordem, int maxCompCod) const {
    Codigo *cod = new Codigo (); cod->c = 1;
    while ((cod->c + 1 <= maxCompCod) && (ordem >= this->offset[cod->c + 1])) 
      (cod->c)++;
    cod->codigo = ordem - this->offset[cod->c] + this->base[cod->c];
    return cod;
  }
  void HuffmanByte::escreve (Codigo *cod, int maxCompCod) const {
    unsigned char *saida = new unsigned char[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    int logBase2 = (int)ceil(log(this->baseNum)/log(2));
    int mask = (int)pow (2, logBase2) - 1;
    int i = 1; int cTmp = cod->c;
    saida[i] = cod->codigo >> (logBase2*(cod->c - 1));
    if (logBase2 == 7) saida[i] = saida[i] | 128; // @{\it Marca\c{c}\~ao}@
    i++;  (cod->c)--;
    while (cod->c > 0) {
      saida[i] = (cod->codigo >> (logBase2*(cod->c - 1))) & mask;
      i++;  (cod->c)--;
    }
    for (i = 1; i <= cTmp; i++) 
      this->arqComp->write ((char *)&saida[i], sizeof (saida[i]));
    delete [] saida;
  }
  void HuffmanByte::terceiraEtapa (int maxCompCod) const {
    ExtraiPalavra palavras (this->nomeArqDelim, this->nomeArqTxt);
    string *palavra = NULL;
    while ((palavra = palavras.proximaPalavra()) != NULL) {
      // @{\it O primeiro espa\c{c}o depois da palavra n\~ao \'e codificado}@
      if (*palavra == "") { delete palavra; continue; }
      ItemVoc *itemVoc = this->vocabulario->pesquisa (*palavra);      
      delete palavra; int ordem = itemVoc->recuperaOrdem ();
      Codigo *cod = this->codifica (ordem, maxCompCod);
      this->escreve (cod, maxCompCod); delete cod;
    }
  }    
  // @{\it M\'etodos para descompress\~ao}@
  int HuffmanByte::leVetores () {
    int maxCompCod = 0;
    this->arqComp->read ((char *)&maxCompCod, sizeof (maxCompCod));
    if (this->offset) delete [] this->offset;
    this->offset = new int[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    if (this->base) delete [] this->base;
    this->base = new int[maxCompCod + 1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    for (int i = 1; i <= maxCompCod; i++) {
      this->arqComp->read ((char *)&(this->base[i]), sizeof (this->base[i]));
      this->arqComp->read ((char *)&(this->offset[i]), sizeof (this->offset[i]));
    }
    return maxCompCod;
  }
  string *HuffmanByte::leVocabulario (int &n) const {
    this->arqComp->read ((char *)&(n), sizeof (n));
    string *vocabulario = new string[n+1]; // @{\it Ignora a posi\c{c}\~ao 0}@
    for (int i = 1; i <= n; i++) {
      vocabulario[i] = ""; char ch;
      this->arqComp->read(&ch, sizeof (ch));
      while (ch != '\0') {
        vocabulario[i] += ch;
        this->arqComp->read(&ch, sizeof (ch));
      }
    }
    return vocabulario;
  } 
  int HuffmanByte::decodifica (int maxCompCod) const {
    int logBase2 = (int)ceil(log(this->baseNum)/log(2));
    int c = 1; int codigo = 0;
    this->arqComp->read((char *)&codigo, sizeof (char));
    if (this->arqComp->eof()) return -1; // @{\it Fim de arquivo}@
    if (logBase2 == 7) codigo = codigo - 128; // @ {\it Remove o bit de marcacao}@
    while (((c + 1) <= maxCompCod) && ((codigo << logBase2) >= this->base[c+1])) {
      int codigoTmp = 0; this->arqComp->read((char *)&codigoTmp, sizeof (char));              
      codigo = (codigo << logBase2) | codigoTmp; c++;
    }
    return (codigo - this->base[c] + this->offset[c]);
  }    
  bool HuffmanByte::eDelimitador (string delim, char ch) const {
    return (delim.find(ch) != string::npos);
  }
  // @{\it M\'etodo auxiliar utilizado na busca em arquivo comprimido}@  
  string HuffmanByte::atribui (Codigo *cod) const {
    string P = "";
    P += (char)((cod->codigo >> (7*(cod->c - 1))) | 128);
    (cod->c)--;
    while (cod->c > 0) {
      P += (char)((cod->codigo >> (7*(cod->c - 1))) & 127);
      (cod->c)--;
    }       
    return P;
  }
  HuffmanByte::HuffmanByte (string nomeArqDelim, int baseNum, 
                            int m, int maxTamChave)  {
    this->baseNum = baseNum;
    this->base = NULL; this->offset = NULL; this->arqComp = NULL;
    this->nomeArqTxt = ""; this->nomeArqDelim = nomeArqDelim;
    this->vocabulario = new TabelaHash<ItemVoc> (m, maxTamChave);
  }
  void HuffmanByte::compressao (string nomeArqTxt, string nomeArqComp) {
    this->nomeArqTxt = nomeArqTxt;
    filebuf fArqComp;
    fArqComp.open (nomeArqComp.c_str (), ios::out);
    if (this->arqComp) delete this->arqComp;
    this->arqComp = new iostream (&fArqComp);
    this->primeiraEtapa ();
    int maxCompCod = this->segundaEtapa ();
    this->terceiraEtapa (maxCompCod);
    fArqComp.close ();
  }    
  void HuffmanByte::descompressao (string nomeArqTxt, string nomeArqComp) {
    this->nomeArqTxt = nomeArqTxt;
    filebuf fArqComp, fArqDelim, fArqTxt;
    fArqComp.open (nomeArqComp.c_str (), ios::in|ios::out);
    if (this->arqComp) delete this->arqComp;
    this->arqComp = new iostream (&fArqComp);
    fArqDelim.open (this->nomeArqDelim.c_str (), ios::in|ios::out);
    iostream arqDelim (&fArqDelim);
    fArqTxt.open (this->nomeArqTxt.c_str (), ios::out);
    iostream arqTxt (&fArqTxt);
    char linha[MAX_TAM_LINHA]; arqDelim.getline(linha, MAX_TAM_LINHA);
    string delim = linha; delim += "\r\n";
    int maxCompCod = this->leVetores ();
    int n = 0; string *vocabulario = this->leVocabulario (n);
    int ind = 0; string palavraAnt = " ";
    while ((ind = this->decodifica (maxCompCod)) >= 0) {
      if (!eDelimitador (delim, palavraAnt[0]) &&
          !eDelimitador (delim, vocabulario[ind][0])) 
        arqTxt.write (" ", sizeof(char));
      arqTxt.write (vocabulario[ind].c_str(), vocabulario[ind].length ());    
      palavraAnt = vocabulario [ind]; 
    }
    delete [] vocabulario; fArqDelim.close (); fArqTxt.close ();      
  }
  void HuffmanByte::busca (string nomeArqComp) {  
    filebuf fArqComp;
    fArqComp.open (nomeArqComp.c_str (), ios::in);
    if (this->arqComp) delete this->arqComp;
    this->arqComp = new iostream (&fArqComp);
    int maxCompCod = this->leVetores ();
    int n = 0; string *vocabulario = this->leVocabulario (n);
    int codigo = 0; string T = ""; string P = "";
    this->arqComp->read((char *)&codigo, sizeof (char));
    while (!this->arqComp->eof ()) {
      T += (char)codigo;
      this->arqComp->read((char *)&codigo, sizeof (char));        
    }
    while (true) {
      cout << "Padrao (ou s para sair):"; std::cin >> P; int ord = 1;
      if (P == "s") break; 
      for (ord = 1; ord <= n; ord++) if (vocabulario[ord] == P) break;
      if (ord == n+1) { 
        cout << "Padrao:" << P << " nao encontrado" << endl; continue;
      }        
      Codigo *cod = this->codifica (ord, maxCompCod);
      string Padrao = this->atribui (cod); delete cod;
      CasamentoExato::bmh (T, T.length (), Padrao, Padrao.length ());      
    } delete [] vocabulario;
  }   
  HuffmanByte::~HuffmanByte () {
    if (this->base) delete [] this->base;
    if (this->offset) delete [] this->offset;
    if (this->arqComp) delete this->arqComp;
    delete this->vocabulario;
  } 
}
#endif
