#ifndef _ITEMVOC_H_
#define _ITEMVOC_H_
#include "../cap4/Item.h" // @{\it vide Programa~\ref{c_4.0}}@ 
#include <string>
using std::string;
using cap4::Item;
namespace cap8 {
  class ItemVoc : public Item<int> {
  private:
    string palavra;
    int freq, ordem;
  public:
    ItemVoc (string palavra, int freq, int ordem);
    virtual int compara (const Item<int> *it) const;
    virtual void alteraChave (int freq);
    virtual int recuperaChave () const;
    virtual string toString () const;
    virtual void alteraOrdem (int ordem);
    virtual int recuperaOrdem () const;
    virtual string _palavra () const;
    ~ItemVoc () {}
  };

  ItemVoc::ItemVoc (string palavra, int freq, int ordem) {
    this->palavra = palavra;
    this->freq = freq; this->ordem = ordem;
  }
  int ItemVoc::compara (const Item<int> *it) const {
    ItemVoc *item = (ItemVoc*) it;
    if (this->freq < item->freq) return 1;
    else if (this->freq > item->freq) return -1;
    return 0;
  }
  void ItemVoc::alteraChave (int freq) { this->freq = freq; }
  int ItemVoc::recuperaChave () const { return this->freq;}
  string ItemVoc::toString () const { return ""; }
  void ItemVoc::alteraOrdem (int ordem) { this->ordem = ordem; }
  int ItemVoc::recuperaOrdem () const { return this->ordem;}
  string ItemVoc::_palavra () const { return this->palavra; }
}
#endif
